package br.ufma.lsdi.clientapp.viewers;

import br.ufma.lsdi.clientapp.entities.DerivedEvent;
import org.ocpsoft.rewrite.annotation.Join;
import javax.annotation.ManagedBean;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.List;

@ManagedBean
@Join(path = "/", to = "/mainscreen.xhtml")
public class MessagesView {
	private double alertValue = 0;
	private double criticalValue = 0;
	private double avarege = 0;

	private List<DerivedEvent> alertEvents = new ArrayList<>();
	private List<DerivedEvent> criticalEvents = new ArrayList<>();
	private List<DerivedEvent> avaregeEvents = new ArrayList<>();



	public void info() {
//		FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "", getMessage()));
	}





	public String getMessageStyle(){
		String style = "font-size: xx-large;";

		if (alertValue > 30 && alertValue < 50) return style+"background: yellow;";
		if (alertValue >= 40) return style+"background: red;";

		return style+"background: green;";
	}

	public double getAlertValue() {
		return alertValue;
	}

	public void setAlertValue(double alertValue) {
		this.alertValue = alertValue;
	}

	public double getCriticalValue() {
		return criticalValue;
	}

	public void setCriticalValue(double criticalValue) {
		this.criticalValue = criticalValue;
	}

	public double getAvarege() {
		return avarege;
	}

	public void setAvarege(double avarege) {
		this.avarege = avarege;
	}

	public List<DerivedEvent> getAlertEvents() {
		return alertEvents;
	}

	public void setAlertEvents(List<DerivedEvent> alertEvents) {
		this.alertEvents = alertEvents;
	}

	public List<DerivedEvent> getCriticalEvents() {
		return criticalEvents;
	}

	public void setCriticalEvents(List<DerivedEvent> criticalEvents) {
		this.criticalEvents = criticalEvents;
	}

	public List<DerivedEvent> getAvaregeEvents() {
		return avaregeEvents;
	}

	public void setAvaregeEvents(List<DerivedEvent> avaregeEvents) {
		this.avaregeEvents = avaregeEvents;
	}

	public void newAlertEventReceived(DerivedEvent derivedEvent){
		this.alertEvents.add(derivedEvent);
	}

	public void newCriticalEventReceived(DerivedEvent derivedEvent){
		this.criticalEvents.add(derivedEvent);
	}

	public void newAverageEventReceived(DerivedEvent derivedEvent){
		this.avaregeEvents.add(derivedEvent);
	}
}
