package br.ufma.lsdi.clientapp.controller;




import br.ufma.lsdi.clientapp.entities.DerivedEvent;
import br.ufma.lsdi.clientapp.viewers.MessagesView;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


@RestController
public class EventScreenController {

	@Autowired
	private MessagesView messagesView;

	@RequestMapping(value ="/event/alert", method = RequestMethod.POST)
	public void alertEvent(@RequestBody String jsonEvent){
		System.out.println("Alert event received..."+jsonEvent);
		JSONObject evenJObject = new JSONObject(jsonEvent);
		DerivedEvent event = new DerivedEvent();
		event.setrUuid(evenJObject.getString("r_uuid"));
		event.setCapabilities("temperature");
		event.setValue(Double.toString(evenJObject.getDouble("temperature")));
		event.setEventName("AlertMonitor");

		messagesView.setAlertValue(evenJObject.getDouble("temperature"));
		messagesView.newAlertEventReceived(event);
	}

	@RequestMapping(value ="/event/critical", method = RequestMethod.POST)
	public void criticalEvent(@RequestBody String jsonEvent){
		System.out.println("Critical event received..."+jsonEvent);
		JSONObject evenJObject = new JSONObject(jsonEvent);
		DerivedEvent event = new DerivedEvent();
		event.setrUuid(evenJObject.getString("r_uuid"));
		event.setCapabilities("temperature");
		event.setValue(Double.toString(evenJObject.getDouble("temperature")));
		event.setEventName("CriticalMonitor");

		messagesView.setCriticalValue(evenJObject.getDouble("temperature"));
		messagesView.newCriticalEventReceived(event);
	}

	@RequestMapping(value ="/event/average", method = RequestMethod.POST)
	public void averageEvent(@RequestBody String jsonEvent){
		System.out.println("Average event received..."+jsonEvent);

		JSONObject evenJObject = new JSONObject(jsonEvent);
		DerivedEvent event = new DerivedEvent();
		event.setValue(Double.toString(evenJObject.getDouble("average")));
		event.setEventName("average");

		messagesView.setAvarege(evenJObject.getDouble("average"));
		messagesView.newAverageEventReceived(event);
	}

	@RequestMapping(value ="/update/temperature/{temperature}", method = RequestMethod.GET)
	public void startGenerictContextData(@PathVariable String temperature){
		Double temp = Double.valueOf(temperature);
		updateTemperature(temp);
	}

	public void updateTemperature(Double temp){
		System.out.println("Temperatura: "+ temp);

		messagesView.setAlertValue(temp);
	}
}
