/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.lsdi.clientapp.controller;

import br.ufma.lsdi.clientapp.entities.DerivedEvent;
import br.ufma.lsdi.clientapp.viewers.MessagesView;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class EventScreenController {
    @Autowired
    private MessagesView messagesView;

    @RequestMapping(value={"/event/alert"}, method={RequestMethod.POST})
    public void alertEvent(@RequestBody String jsonEvent) {
        System.out.println("Alert event received..." + jsonEvent);
        JSONObject evenJObject = new JSONObject(jsonEvent);
        DerivedEvent event = new DerivedEvent();
        event.setrUuid(evenJObject.getString("r_uuid"));
        event.setCapabilities("temperature");
        event.setValue(Double.toString(evenJObject.getDouble("temperature")));
        event.setEventName("AlertMonitor");
        this.messagesView.setAlertValue(evenJObject.getDouble("temperature"));
        this.messagesView.newAlertEventReceived(event);
    }

    @RequestMapping(value={"/event/critical"}, method={RequestMethod.POST})
    public void criticalEvent(@RequestBody String jsonEvent) {
        System.out.println("Critical event received..." + jsonEvent);
        JSONObject evenJObject = new JSONObject(jsonEvent);
        DerivedEvent event = new DerivedEvent();
        event.setrUuid(evenJObject.getString("r_uuid"));
        event.setCapabilities("temperature");
        event.setValue(Double.toString(evenJObject.getDouble("temperature")));
        event.setEventName("CriticalMonitor");
        this.messagesView.setCriticalValue(evenJObject.getDouble("temperature"));
        this.messagesView.newCriticalEventReceived(event);
    }

    @RequestMapping(value={"/event/average"}, method={RequestMethod.POST})
    public void averageEvent(@RequestBody String jsonEvent) {
        System.out.println("Average event received..." + jsonEvent);
        JSONObject evenJObject = new JSONObject(jsonEvent);
        DerivedEvent event = new DerivedEvent();
        event.setValue(Double.toString(evenJObject.getDouble("average")));
        event.setEventName("average");
        this.messagesView.setAvarege(evenJObject.getDouble("average"));
        this.messagesView.newAverageEventReceived(event);
    }

    @RequestMapping(value={"/update/temperature/{temperature}"}, method={RequestMethod.GET})
    public void startGenerictContextData(@PathVariable String temperature) {
        Double temp = Double.valueOf(temperature);
        this.updateTemperature(temp);
    }

    public void updateTemperature(Double temp) {
        System.out.println("Temperatura: " + temp);
        this.messagesView.setAlertValue(temp.doubleValue());
    }
}

