package br.ufma.lsdi.clientapp.viewers;

import br.ufma.lsdi.clientapp.entities.DerivedEvent;
import br.ufma.lsdi.clientapp.entities.Event;
import br.ufma.lsdi.clientapp.helper.RestRequestHelper;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ocpsoft.rewrite.annotation.Join;
import org.primefaces.PrimeFaces;

import javax.annotation.ManagedBean;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import java.io.IOException;
import java.util.*;

@ManagedBean
@Join(path = "/", to = "/mainscreen.xhtml")
public class EventsView {
	private String cep_cataloger = "localhost";
	private String rUuid = "29b13d11-5ed1-47fd-b329-03df161d0893";
	private String definition = defaultStatement();
	private String derivatedEventName;

	private List<Event> events = new ArrayList<>();
	private List<DerivedEvent> derivedEvents = new ArrayList<>();



	public void takePrimitivesEvents(){
		events = new ArrayList<>();

		String urlString = "http://"+cep_cataloger+":8090/primitives_available/"+rUuid;

		String result = null;
		try {
			result = RestRequestHelper.sendRequestGetData(urlString);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}

		JSONObject jsonObject = new JSONObject(result);

		JSONObject jsonEventObject = (JSONObject) jsonObject.get("response");

		Iterator<String> i = jsonEventObject.keys();
		while (i.hasNext()){
			System.out.println(jsonEventObject.toString());

			String eventUuidString = i.next();

			Event event = new Event();
			event.setUuid(eventUuidString);

			JSONObject eventMetaData = (JSONObject) jsonEventObject.get(eventUuidString);
			event.setResourceUuid((String) eventMetaData.get("ResourceUuid"));
			event.setCapability((String) eventMetaData.get("Capability"));
			event.setEventName((String) eventMetaData.get("EventName"));


			events.add(event);
		}
	}

	public void takeDerivedEvents(){
		derivedEvents = new ArrayList<>();

		String urlString = "http://"+cep_cataloger+":8090/event_types";

		/*obtendo os eventos derivados cadastrados*/
		String result = null;
		try {
			result = RestRequestHelper.sendRequestGetData(urlString);
			result = ("{\"response\" : "+result+"}").replaceAll("null","\"null\"");
			System.out.println(result);

		} catch (Exception e) {
			e.printStackTrace();
			return;
		}

		JSONObject response = new JSONObject(result);
		JSONArray eventJsonArray = (JSONArray) response.get("response");
		for(int i = 0; i < eventJsonArray.length();i++) {
			JSONObject eventJsonObject = eventJsonArray.getJSONObject(i);

			DerivedEvent derivedEvent = new DerivedEvent();
			derivedEvent.setUuid(eventJsonObject.getString("uuid"));
			derivedEvent.setDefinition((String) eventJsonObject.get("Definition"));
			derivedEvent.setInputs((String) eventJsonObject.get("Inputs"));

			/*obtendo os web hooks para cada evento*/
			String wbhooksUrl = "http://" + cep_cataloger + ":8090/web_hooks/" + derivedEvent.getUuid();
			String result2 = null;
			try {
				result2 = RestRequestHelper.sendRequestGetData(wbhooksUrl);
			} catch (Exception e) {
				e.printStackTrace();
				return;
			}
			JSONArray wbJsonObjet = (JSONArray) new JSONObject(result2).get(derivedEvent.getUuid());
			Iterator it = wbJsonObjet.iterator();
			while (it.hasNext())
				derivedEvent.getWebHook().add((String) it.next());

			derivedEvents.add(derivedEvent);
		}
	}

	public void addNewWebHook(DerivedEvent selectedEvent){
//        String resourUuid = "9bf3b284-cf69-4415-bf60-17103237b22b"; //TODO para LSDi
//		  String resourUuid = "918be86e-9344-4e6f-8948-545ed10d01e6"; //TODO para Localmente
		System.out.println("Selected event..."+selectedEvent.getUuid());
		String urlString = "http://"+cep_cataloger+":8090/web_hooks";


		/* Adicionando web hook cep-cataloger*/
		String newWhook = "{" +
			"\"uuid\" : \""+selectedEvent.getUuid()+"\"," +
			"\"url\" : \""+selectedEvent.getTempWebHook()+"\"" +
			"}";

		try {
			RestRequestHelper.sendRequestPostData(newWhook, urlString);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}
		selectedEvent.getWebHook().add(selectedEvent.getTempWebHook());
	}

	public void defineNewDerivedEvent(){
		List<Event> selectPEvents = getSelectedPrimitivesEvents();
		if(events.size() == 0 || selectPEvents.size() == 0){
			FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "ERROR", "No Primitive Event Selected.");

			PrimeFaces.current().dialog().showMessageDynamic(message);
			return;
		}


		String capabilities = getCapabilitiesAsString(selectPEvents);
		String inputs = getInpusAsString(selectPEvents);

		String tmpString = "{ " +
			"\"name\" : \""+ derivatedEventName+"\"," +
			"\"definition\" : \""+definition+"\", " +
			"\"resourceUuid\" : \""+rUuid+"\"," +
			"\"capabilities\" : [\""+capabilities+"\"]," +
			"\"inputs\" : \""+inputs+"\"}" +
			"}";

		String url = "http://"+cep_cataloger+":8090/event_types";

		System.out.println("Add Statement: "+tmpString );

		try {
			RestRequestHelper.sendRequestPostData(tmpString, url);
		} catch (Exception e) {
			e.printStackTrace();
			return;
		}

		DerivedEvent derivedEvent = new DerivedEvent();
		derivedEvent.setUuid("");
		derivedEvent.setrUuid(rUuid);
		derivedEvent.setDefinition(definition);
		derivedEvent.setCapabilities(capabilities);
		derivedEvent.setInputs(inputs);

		derivedEvents.add(derivedEvent);
	}

	private List<Event> getSelectedPrimitivesEvents() {
		List<Event> selectedEvents = new ArrayList<>();
		Iterator i = events.iterator();
		while (i.hasNext()){
			Event event = (Event) i.next();
			if(event.isSelected())
				selectedEvents.add(event);
		}
		return selectedEvents;
	}


	public void dynamicDefinitionView(){
		Map<String,Object> options = new HashMap<>();
		options.put("modal", true);
		options.put("width", 640);
		options.put("height", 340);
		options.put("contentWidth", "100%");
		options.put("contentHeight", "100%");
		options.put("headerElement", "customheader");

		PrimeFaces.current().dialog().openDynamic("statementscreen", options, null);

	}


	private String defaultStatement(){
		String stm = "";
		if(rUuid != null){
			String eventName = "INTCT_"+rUuid.toUpperCase().replaceAll("-","")+"_TEMPERATURE";
			stm = "SELECT * FROM "+eventName+" AS temp WHERE "+eventName+".temperature > 30"; //Works
			//stm = "SELECT average from "+eventName+"#length(5)#uni(temperature)"; //
		}
		return stm;
	}

	private String getCapabilitiesAsString(List<Event> eventList){
		String result = "";
		for(int i = 0; i < eventList.size() - 1;i++){
			result = result.concat(eventList.get(i).getCapability());
		}
		result = result.concat(eventList.get(eventList.size()-1).getCapability());

		return result;
	}

	private String getInpusAsString(List<Event> eventList){
		String result = "";
		for(int i = 0; i < eventList.size() - 1;i++){
			result = result.concat(eventList.get(i).getUuid());
		}
		result = result.concat(eventList.get(eventList.size()-1).getUuid());

		return result;
	}


	private String defaultWebHook() {
		return "http://localhost:8585/event/alert";
	}


	public String getrUuid() {
		return rUuid;
	}

	public void setrUuid(String rUuid) {
		this.rUuid = rUuid;
	}

	public List<Event> getEvents() {
		return events;
	}

	public List<DerivedEvent> getDerivedEvents(){
		return derivedEvents;
	}

	public String getDefinition() {
		return definition;
	}

	public void setDefinition(String definition) {
		this.definition = definition;
	}

	public String getDerivatedEventName() {
		return derivatedEventName;
	}

	public void setDerivatedEventName(String derivatedEventName) {
		this.derivatedEventName = derivatedEventName;
	}
}
