/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.lsdi.clientapp.viewers;

import br.ufma.lsdi.clientapp.entities.DerivedEvent;
import br.ufma.lsdi.clientapp.entities.Event;
import br.ufma.lsdi.clientapp.helper.RestRequestHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.ManagedBean;
import javax.faces.application.FacesMessage;
import org.json.JSONArray;
import org.json.JSONObject;
import org.ocpsoft.rewrite.annotation.Join;
import org.primefaces.PrimeFaces;

@ManagedBean
@Join(path="/", to="/mainscreen.xhtml")
public class EventsView {
    private String cep_cataloger = "localhost";
    private String rUuid = "29b13d11-5ed1-47fd-b329-03df161d0893";
    private String definition = this.defaultStatement();
    private String derivatedEventName;
    private List<Event> events = new ArrayList();
    private List<DerivedEvent> derivedEvents = new ArrayList();

    public void takePrimitivesEvents() {
        this.events = new ArrayList();
        String urlString = "http://" + this.cep_cataloger + ":8090/primitives_available/" + this.rUuid;
        String result = null;
        try {
            result = RestRequestHelper.sendRequestGetData((String)urlString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        JSONObject jsonObject = new JSONObject(result);
        JSONObject jsonEventObject = (JSONObject)jsonObject.get("response");
        Iterator i = jsonEventObject.keys();
        while (i.hasNext()) {
            System.out.println(jsonEventObject.toString());
            String eventUuidString = (String)i.next();
            Event event = new Event();
            event.setUuid(eventUuidString);
            JSONObject eventMetaData = (JSONObject)jsonEventObject.get(eventUuidString);
            event.setResourceUuid((String)eventMetaData.get("ResourceUuid"));
            event.setCapability((String)eventMetaData.get("Capability"));
            event.setEventName((String)eventMetaData.get("EventName"));
            this.events.add(event);
        }
    }

    public void takeDerivedEvents() {
        this.derivedEvents = new ArrayList();
        String urlString = "http://" + this.cep_cataloger + ":8090/event_types";
        String result = null;
        try {
            result = RestRequestHelper.sendRequestGetData((String)urlString);
            result = ("{\"response\" : " + result + "}").replaceAll("null", "\"null\"");
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        JSONObject response = new JSONObject(result);
        JSONArray eventJsonArray = (JSONArray)response.get("response");
        for (int i = 0; i < eventJsonArray.length(); ++i) {
            JSONObject eventJsonObject = eventJsonArray.getJSONObject(i);
            DerivedEvent derivedEvent = new DerivedEvent();
            derivedEvent.setUuid(eventJsonObject.getString("uuid"));
            derivedEvent.setDefinition((String)eventJsonObject.get("Definition"));
            derivedEvent.setInputs((String)eventJsonObject.get("Inputs"));
            String wbhooksUrl = "http://" + this.cep_cataloger + ":8090/web_hooks/" + derivedEvent.getUuid();
            String result2 = null;
            try {
                result2 = RestRequestHelper.sendRequestGetData((String)wbhooksUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
            JSONArray wbJsonObjet = (JSONArray)new JSONObject(result2).get(derivedEvent.getUuid());
            Iterator it = wbJsonObjet.iterator();
            while (it.hasNext()) {
                derivedEvent.getWebHook().add((String)it.next());
            }
            this.derivedEvents.add(derivedEvent);
        }
    }

    public void addNewWebHook(DerivedEvent selectedEvent) {
        System.out.println("Selected event..." + selectedEvent.getUuid());
        String urlString = "http://" + this.cep_cataloger + ":8090/web_hooks";
        String newWhook = "{\"uuid\" : \"" + selectedEvent.getUuid() + "\",\"url\" : \"" + selectedEvent.getTempWebHook() + "\"}";
        try {
            RestRequestHelper.sendRequestPostData((String)newWhook, (String)urlString);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        selectedEvent.getWebHook().add(selectedEvent.getTempWebHook());
    }

    public void defineNewDerivedEvent() {
        List selectPEvents = this.getSelectedPrimitivesEvents();
        if (this.events.size() == 0 || selectPEvents.size() == 0) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, "ERROR", "No Primitive Event Selected.");
            PrimeFaces.current().dialog().showMessageDynamic(message);
            return;
        }
        String capabilities = this.getCapabilitiesAsString(selectPEvents);
        String inputs = this.getInpusAsString(selectPEvents);
        String tmpString = "{ \"name\" : \"" + this.derivatedEventName + "\",\"definition\" : \"" + this.definition + "\", \"resourceUuid\" : \"" + this.rUuid + "\",\"capabilities\" : [\"" + capabilities + "\"],\"inputs\" : \"" + inputs + "\"}}";
        String url = "http://" + this.cep_cataloger + ":8090/event_types";
        System.out.println("Add Statement: " + tmpString);
        try {
            RestRequestHelper.sendRequestPostData((String)tmpString, (String)url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        DerivedEvent derivedEvent = new DerivedEvent();
        derivedEvent.setUuid("");
        derivedEvent.setrUuid(this.rUuid);
        derivedEvent.setDefinition(this.definition);
        derivedEvent.setCapabilities(capabilities);
        derivedEvent.setInputs(inputs);
        this.derivedEvents.add(derivedEvent);
    }

    private List<Event> getSelectedPrimitivesEvents() {
        ArrayList<Event> selectedEvents = new ArrayList<Event>();
        for (Event event : this.events) {
            if (!event.isSelected()) continue;
            selectedEvents.add(event);
        }
        return selectedEvents;
    }

    public void dynamicDefinitionView() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("modal", true);
        options.put("width", 640);
        options.put("height", 340);
        options.put("contentWidth", "100%");
        options.put("contentHeight", "100%");
        options.put("headerElement", "customheader");
        PrimeFaces.current().dialog().openDynamic("statementscreen", options, null);
    }

    private String defaultStatement() {
        String stm = "";
        if (this.rUuid != null) {
            String eventName = "INTCT_" + this.rUuid.toUpperCase().replaceAll("-", "") + "_TEMPERATURE";
            stm = "SELECT * FROM " + eventName + " AS temp WHERE " + eventName + ".temperature > 30";
        }
        return stm;
    }

    private String getCapabilitiesAsString(List<Event> eventList) {
        String result = "";
        for (int i = 0; i < eventList.size() - 1; ++i) {
            result = result.concat(eventList.get(i).getCapability());
        }
        result = result.concat(eventList.get(eventList.size() - 1).getCapability());
        return result;
    }

    private String getInpusAsString(List<Event> eventList) {
        String result = "";
        for (int i = 0; i < eventList.size() - 1; ++i) {
            result = result.concat(eventList.get(i).getUuid());
        }
        result = result.concat(eventList.get(eventList.size() - 1).getUuid());
        return result;
    }

    private String defaultWebHook() {
        return "http://localhost:8585/event/alert";
    }

    public String getrUuid() {
        return this.rUuid;
    }

    public void setrUuid(String rUuid) {
        this.rUuid = rUuid;
    }

    public List<Event> getEvents() {
        return this.events;
    }

    public List<DerivedEvent> getDerivedEvents() {
        return this.derivedEvents;
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public String getDerivatedEventName() {
        return this.derivatedEventName;
    }

    public void setDerivatedEventName(String derivatedEventName) {
        this.derivatedEventName = derivatedEventName;
    }
}

